/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_1060;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

public class ImageElement
extends SizedBookElement {
    public ImageData image;
    public int colorMultiplier;
    private ItemElement itemElement;

    public ImageElement(ImageData image) {
        this(image, 0xFFFFFF);
    }

    public ImageElement(ImageData image, int colorMultiplier) {
        this(image.x, image.y, image.width, image.height, image, colorMultiplier);
    }

    public ImageElement(int x, int y, int width, int height, ImageData image) {
        this(x, y, width, height, image, image.colorMultiplier);
    }

    public ImageElement(int x, int y, int width, int height, ImageData image, int colorMultiplier) {
        super(x, y, width, height);
        this.image = image;
        if (image.x != -1) {
            x = image.x;
        }
        if (image.y != -1) {
            y = image.y;
        }
        if (image.width != -1) {
            width = image.width;
        }
        if (image.height != -1) {
            height = image.height;
        }
        if (image.colorMultiplier != 0xFFFFFF) {
            colorMultiplier = image.colorMultiplier;
        }
        this.x = x == -1 ? 0 : x;
        this.y = y == -1 ? 0 : y;
        this.width = width;
        this.height = height;
        this.colorMultiplier = colorMultiplier;
        if (image.item != null) {
            this.itemElement = new ItemElement(0, 0, 1.0f, (Collection<class_1799>)image.item.getItems());
        }
    }

    @Override
    public void draw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks, class_327 fontRenderer) {
        class_4587 matrixStack = guiGraphics.method_51448();
        float r = (float)(this.colorMultiplier >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.colorMultiplier >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.colorMultiplier & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        if (this.image.item == null) {
            ImageElement.blitRaw(guiGraphics, Objects.requireNonNullElse(this.image.location, class_1060.field_5285), this.x, this.y, this.width, this.height, this.image.u, this.image.u + this.image.uw, this.image.v, this.image.v + this.image.vh, this.image.texWidth, this.image.texHeight);
        } else {
            matrixStack.method_22903();
            matrixStack.method_46416((float)this.x, (float)this.y, 0.0f);
            matrixStack.method_22905((float)this.width / 16.0f, (float)this.height / 16.0f, 1.0f);
            this.itemElement.draw(guiGraphics, mouseX, mouseY, partialTicks, fontRenderer);
            matrixStack.method_22909();
        }
    }

    public static void blitRaw(class_332 guiGraphics, class_2960 texture, int x, int y, int w, int h, int minU, int maxU, int minV, int maxV, float tw, float th) {
        guiGraphics.method_25295(texture, x, x + w, y, y + h, 0, (float)minU / tw, (float)maxU / tw, (float)minV / th, (float)maxV / th);
    }
}

